<?php
/**
 * Всплывающее окно активации услуг (продвижение ОБ)
 * @var $this Job
 */
if( ! bff::servicesEnabled()) return;
if( ! isset($nTypeID)) $nTypeID = Job::TYPE_RESUME;
switch ($nTypeID){
    case Job::TYPE_RESUME:
        $nServiceUp = Job::SERVICE_RESUME_UP;
        $nServiceMark = Job::SERVICE_RESUME_MARK;
        $nServiceFix = Job::SERVICE_RESUME_FIX;
        $sSvcKeyword = 'resume_';
        break;
    case Job::TYPE_VACANCY:
        $nServiceUp = Job::SERVICE_VACANCY_UP;
        $nServiceMark = Job::SERVICE_VACANCY_MARK;
        $nServiceFix = Job::SERVICE_VACANCY_FIX;
        $sSvcKeyword = 'vacancy_';
        break;
}
$svc = Svc::model()->svcListing(Svc::TYPE_SERVICE, $this->module_name);
$psystems = Bills::getPaySystems(false);
$currency = Site::currencyDefault();
$balance  = User::balance();

$paySystemsBlock = function($nSvcPrice) use ($balance, $psystems)
{
    if ($balance >= $nSvcPrice || empty($psystems)) {
        return;
    }

    reset($psystems);
    ?><input type="hidden" name="ps" value="<?= key($psystems); ?>" /><?
    if (sizeof($psystems) > 1) {
        ?>
        <div class="pay-systems mb15">
            <? $i = 0; foreach($psystems as $k=>$v) { ?>
                <div class="item<? if(!$i++){ ?> active<? } ?> <?= $v['class'] ?>" data-ps="<?= HTML::escape($k) ?>">
                    <div class="text"><a href="javascript:void(0);"><?= $v['title'] ?></a></div>
                </div>
            <? } ?>
            <div class="clear"></div>
        </div>
    <?
    }
}
?>
<script type="text/javascript">
    <? js::start(); ?>
    var jJobItemsPromote = (function(){
        var $popup = false, popup, $blocks, $links, processing = false,
            params = {id: 0, hash:''}, itemState = {};

        $(function(){
            popup = app.popup('job-promote', '#popup-job-promote', false, {onInit: function($p){}, scroll:true});
            $popup = popup.getPopup();
            $blocks = $popup.find('.bp-block');
            $links = $popup.find('.bp-block-link');
            $popup.on('click', '.pay-systems .item', function(e){
                nothing(e);
                var $form = $(this).closest('form');
                $form.find('[name="ps"]').val( $(this).data('ps') );
                $(this).addClass('active').siblings().removeClass('active');
            });
            params.hash = app.csrf_nonce;
        });

        return {
            promote: function(id, preview, e)
            {
                if( ! itemState.hasOwnProperty(id) ) {
                    bff.ajax('<?= bff::urlAjax('job','item-promote-data') ?>', {item_id:id,hash:app.csrf_nonce, type_id:<?= $nTypeID ?>}, function(data, errors){
                        if(data && data.success) {
                            itemState[id] = data;
                            jJobItemsPromote.promote(id, preview, e);
                        }
                    });
                    return;
                }

                $('#job-promote-id', $popup).val(id);
                if( preview ) {
                    $('#job-promote-itempreview', $popup).html(preview);
                }
                var state = itemState[id];
                var $marked = $popup.find('.marked-state').hide();
                if( intval(state.marked) > 0 ) {
                    $marked.html(state.marked_to).show();
                }
                var $fixed = $popup.find('.fixed-state').hide();
                if( intval(state.fixed) > 0 ) {
                    $fixed.html(state.fixed_to).show();
                }
                var $vip = $popup.find('.vip-state').hide();
                if( intval(state.vip) > 0 ) {
                    $vip.html(state.vip_to).show();
                }
                params.id = id;
                popup.show(e);
            },
            selectBlock: function(link)
            {
                link = $(link);
                var $b = link.parent().next();
                $blocks.addClass('displaynone').filter($b).removeClass('displaynone');
                $links.removeClass('active').addClass('ajax');
                link.toggleClass('active ajax');
                $b.find('.error:first').hide();
                return false;
            },
            submit: function(btn)
            {
                if(processing) return;

                var $form = $(btn.form); btn = $(btn);
                var $err = $form.find('.error:first');
                bff.ajax('<?= bff::urlAjax('job','item-promote') ?>', $form.serialize()+'&'+$.param(params), function(data, errors){
                    if(data && data.success) {
                        if( data.hasOwnProperty('form') ) {
                            app.pay(data.form);
                        } else if( data.hasOwnProperty('redirect') ) {
                            bff.redirect(data.redirect);
                        } else {
                            location.reload();
                        }
                    } else {
                        app.showError($err, errors);
                    }
                }, function(p) {
                    processing = p;
                    if(p) btn.prop('disabled', true).val('<?= _t('', 'подождите...'); ?>');
                    else  btn.prop('disabled', false).val('<?= _t('', 'оплатить'); ?>');
                });
            }
        };
    }());
    <? js::stop(); ?>
</script>

<div class="popup displaynone" id="popup-job-promote" style="width: 650px; margin-left: -270px; top:-150px;">
    <div class="popup-title"><?= _t('', 'Продвинуть объявление:'); ?></div>
    <div class="close"><span>x</span> <a href="#" class="close"><?= _t('', 'закрыть'); ?></a></div>
    <div class="content-popup" style="margin-top: 5px;">

        <div id="job-promote-itempreview" class="estate-other" style="margin-left: 35px;"></div>

        <div class="form-box" id="svc-promote-block" style="padding-left: 35px;">
            <? /* Поднятие */ ?>
            <? if( ! empty($svc[$sSvcKeyword.'up']) && ! empty($svc[$sSvcKeyword.'up']['on']) ) { $s =& $svc[$sSvcKeyword.'up']; ?>
                <h3><a class="active bp-block-link" href="#" onclick="return jJobItemsPromote.selectBlock(this);"><?= _t('', 'Поднять объявление'); ?></a></h3>
                <div class="bp-block">
                    <form>
                        <input type="hidden" name="svc" value="<?= $nServiceUp ?>" />
                        <div class="error mb15" style="display: none;"></div>
                        <div class="mb15"><?= $s['description'][LNG] ?></div>
                        <? $paySystemsBlock($s['price']); ?>
                        <div class="mb15">
                            <?= _t('', 'Стоимость: <b>[price]</b>', array('price'=>$s['price'].' '.$currency)); ?>
                        </div>
                        <div class="btn mr10 mb10 left"><input type="button" onclick="jJobItemsPromote.submit(this);" value="<?= _t('', 'Оплатить'); ?>" /><i></i></div>
                        <div class="clear"></div>
                    </form>
                    <div class="separator"></div>
                </div>
            <? } ?>

            <? /* Выделение */ ?>
            <? if( ! empty($svc[$sSvcKeyword.'mark']) && ! empty($svc[$sSvcKeyword.'mark']['on']) ) { $s =& $svc[$sSvcKeyword.'mark']; ?>
                <h3><a class="ajax bp-block-link" href="#" onclick="return jJobItemsPromote.selectBlock(this);"><?= _t('', 'Выделить объявление'); ?></a></h3>
                <div class="bp-block displaynone">
                    <form>
                        <input type="hidden" name="svc" value="<?= $nServiceMark ?>" />
                        <div class="error mb15" style="display: none;"></div>
                        <div class="mb15"><?= $s['description'][LNG] ?></div>
                        <? $paySystemsBlock($s['price']); ?>
                        <div class="mb15">
                            <?= _t('', 'Стоимость: <b>[price]</b>', array('price'=>$s['price'].' '.$currency)); ?>
                        </div>
                        <div class="marked-state mb15" style="display: none;"></div>
                        <div class="btn mr10 mb10 left"><input type="button" onclick="jJobItemsPromote.submit(this);" value="<?= _t('', 'Оплатить'); ?>" /><i></i></div>
                        <div class="clear"></div>
                    </form>
                    <div class="separator"></div>
                </div>
            <? } ?>

            <? /* Закрепление */ ?>
            <? if( ! empty($svc[$sSvcKeyword.'fix']) && ! empty($svc[$sSvcKeyword.'fix']['on']) ) { $s =& $svc[$sSvcKeyword.'fix']; ?>
                <h3><a class="ajax bp-block-link" href="#" onclick="return jJobItemsPromote.selectBlock(this);"><?= _t('', 'Закрепить объявление'); ?></a></h3>
                <div class="bp-block displaynone">
                    <form>
                        <input type="hidden" name="svc" value="<?= $nServiceFix ?>" />
                        <div class="error mb15" style="display: none;"></div>
                        <div class="mb15"><?= $s['description'][LNG] ?></div>
                        <? $paySystemsBlock($s['price']); ?>
                        <div class="mb15">
                            <?= _t('', 'Стоимость: <b>[price]</b>', array('price'=>$s['price'].' '.$currency)); ?>
                        </div>
                        <div class="fixed-state mb15" style="display: none;"></div>
                        <div class="btn mr10 mb10 left"><input type="button" onclick="jJobItemsPromote.submit(this);" value="<?= _t('', 'Оплатить'); ?>" /><i></i></div>
                        <div class="clear"></div>
                    </form>
                    <div class="separator"></div>
                </div>
            <? } ?>

        </div>

    </div>
</div>