<?php
    if( ! User::id()) { ?>
    <div class="h1-wrap">
        <h1><?= _t('pub', 'Добавление новости'); ?></h1>
        <p class="send-comment-att mt20"><?= _t('pub','[a1:start]Зарегистрируйтесь[a1:stop] или [a2:start]войдите[a2:stop], чтобы добавить новость', array(
                'a1:start' => '<a href="'.Users::url('register').'" onclick="app.popup(\'reg\').show(event);">',
                'a1:stop'  => '</a>',
                'a2:start' => '<a href="'.Users::url('login').'" onclick="app.popup(\'login\').show(event);">',
                'a2:stop'  => '</a>',
            )); ?> <i class="say"></i></p>
    </div>
    <?  return; }
    $sCategories = $this->categoriesGet($this->type, true, array('sel'=>0,'empty'=>_t('','Выбрать')));
    tpl::includeJS(array('qquploader', 'fancybox'), true);

?>

<div class="h1-wrap">
    <h1><?= _t('pub', 'Добавление новости'); ?></h1>
    <ul class="form-ch mt20">
        <li><?= _t('', 'Поля, отмеченные звездочкой[span], обязательны к заполнению.', array(
                'span' => '<span class="z-att">*</span>',
            )); ?></li>
    </ul>
    <div class="form-box object-add">
        <form  action="/narod/submit/" method="post" enctype="multipart/form-data" id="pub-narod-form">
            <input type="hidden" name="hash" value="<?= $this->security->getToken() ?>" />
            <input type="hidden" name="act" value="save" />
            <div class="error mb20 j-error" style="display: none;"></div>
            <table>
                <tr>
                    <td class="td1"><?= _t('pub','Рубрика:'); ?><span class="z-att">*</span></td>
                    <td><select name="cat" class="j-category" autocomplete="off"><?= $sCategories ?></select></td>
                </tr>
                <? if ( ! Geo::cityIsOne()) { ?>
                    <tr>
                        <td class="td1"><?= _t('','Город:'); ?></td>
                        <td><?= Geo::cityOptionsSelect(false, false, 'city_id', array(), _t('pub','Выбрать')); ?></td>
                    </tr>
                <? } ?>
                <tr>
                    <td class="td1"><?= _t('pub','Заголовок новости:'); ?><span class="z-att">*</span></td>
                    <td><div class="inp inp-w1"><input type="text" name="title" autocomplete="off" maxlength="150" class="j-title" /><i></i></div></td>
                </tr>
                <tr>
                    <td class="td1"><?= _t('pub','Текст новости:'); ?><span class="z-att">*</span></td>
                    <td>
                        <script type="text/javascript">var pubNarodFormWY = null;</script>
                        <?= tpl::jwysiwyg('', 'narod_content,content', 460, 100, false, 'pubNarodFormWY'); ?>
                    </td>
                </tr>
                <tr>
                    <td class="td1"><?= _t('', 'Фотографии'); ?></td>
                    <td>
                        <?
                        if( ! empty($settings['gallery_photos_limit'])){
                            $t = _t('', 'Вы можете загрузить не более [photos] в формате JPG или PNG, объемом не более [s]', array(
                                'photos' => tpl::declension($settings['gallery_photos_limit'], 'фотография;фотографии;фотографий'),
                                's' => tpl::filesize($settings['images_maxsize'])));
                        }else{
                            $t = _t('', 'Вы можете загрузить фотографии в формате JPG или PNG, объемом не более [s]', array('s' => tpl::filesize($settings['images_maxsize'])));
                        }
                        ?>
                        <p class="inform-att f12"><?= $t ?> &nbsp;<span class="progress" id="narod-photos-progress" style="display:none;"></span><i></i></p>
                        <div class="photos-edit">
                            <div id="narod-photos-list">
                            </div>
                            <br class="clear" />
                            <div id="narod-photos-upload" style="height: 20px; width: 160px"><a href="javascript:void(0);" class="ajax"><?= _t('', 'Загрузить фотографии'); ?></a></div>
                        </div>
                        <br />
                    </td>
                </tr>

                <tr>
                    <td></td>
                    <td>
                        <div class="btn mr10 left"><input type="button" class="j-submit" value="<?= _t('pub','добавить новость'); ?>" /><i></i></div>
                    </td>
                </tr>
            </table>
        </form>
        <i class="say"></i>
        <script type="text/javascript">
            <? js::start(); ?>
            $(function(){
                var $form  = $('#pub-narod-form');
                var $err   = $form.find('.j-error');
                var $title = $form.find('.j-title');
                var $cat   = $form.find('.j-category');

                bff.iframeSubmit($form, function(data, errors){
                    if (data && data.success) {
                        app.showError($err, '<?= _t('pub','Народная новость была успешно отправлена на модерацию'); ?>', true, true);
                        $form.get(0).reset();
                        narodPhotos.reset();
                    } else {
                        app.showError($err, errors);
                    }
                });

                $form.on('click', '.j-submit', function(){
                    app.fieldError($title, false);
                    if (intval($cat.val())<=0) {
                        app.showError($err, '<?= _t('pub','Укажите рубрику'); ?>');
                        $cat.focus();
                        return;
                    }

                    if (!$.trim($title.val()).length) {
                        app.showError($err, '<?= _t('pub','Укажите заголовок'); ?>');
                        app.fieldError($title, true, true);
                        return;
                    }
                    var len = pubNarodFormWY.getContentText().length;
                    if (len <= 0) {
                        app.showError($err, '<?= _t('pub','Укажите текст новости'); ?>');
                        pubNarodFormWY.focus(true);
                        return;
                    }
                    if (len <= 10) {
                        app.showError($err, '<?= _t('pub','Короткий текст'); ?>');
                        pubNarodFormWY.focus(true);
                        return;
                    }

                    $form.submit();
                });
            });
            var narodPhotos = (function()
            {
                var uploader, url = '<?= bff::urlAjax('publications&ev=narod_submit','') ?>';
                var $form, $block, $progress;
                var itemID = 0;

                $(function(){

                    $form     = $('#pub-narod-form');
                    $block    = $('#narod-photos-list', $form);
                    $progress = $('#narod-photos-progress', $form);

                    // init uploader
                    uploader = new qq.FileUploaderBasic({
                        button: $('#narod-photos-upload', $form).get(0),
                        action: url+'img-upload&id='+itemID,
                        limit: <?= $settings['gallery_photos_limit'] ?>,
                        uploaded: 0,
                        multiple: true,
                        onSubmit: function(id, fileName) {
                            $progress.show();
                        },
                        onComplete: function(id, fileName, data) {
                            if(data && data.success) {
                                $block.append('<div class="item">\
                                <input type="hidden" name="filename[]" value="'+data.filename+'" />\
                                <a href="'+data.o+'" target="_blank" rel="narod_photos"><img src="'+data.t+'" alt=""></a>\
                                <a href="#" class="del" rel="'+data.filename+'"><?= _t('', 'Удалить'); ?></a>\
                            </div>');
                                $('a[rel="narod_photos"]', $block).fancybox();
                            } else {
                                if(data.errors) {
                                    app.showError($('#narod-error'), data.errors, false);
                                }
                            }
                            if( ! uploader.getInProgress()) {
                                $progress.hide();
                            }
                            return true;
                        }
                    });

                    $block.delegate('div a.del', 'click', function(e){
                        nothing(e);
                        var lnk = $(this);
                        if(confirm('<?= _t('', 'Удалить фото?'); ?>')) {
                            var fn = lnk.attr('rel');
                            bff.ajax(url+'img-delete', {filename: [fn], id: itemID}, function(data) {
                                if(data) {
                                    lnk.parent().remove();
                                    uploader.decrementUploaded();
                                }
                            });
                        } return false;
                    });

                    var lostProcessed = false;
                    $(window).bind('beforeunload', function(){
                        if( ! lostProcessed) {
                            var $fn = $block.find('a.del');
                            if($fn.length > 0) {
                                lostProcessed = true;
                                var fn = []; $fn.each(function(){ fn.push($(this).attr('rel')); });
                                bff.ajax(url+'img-delete',{id:itemID,filename:fn},function(){},false,{async:false});
                            }
                        }
                    });
                });

                return {
                    reset:function(){
                        $block.empty();
                        uploader.resetUploaded();
                    }
                };

            }());

            <? js::stop(); ?>
        </script>
    </div>
</div>
