<?php use bff\db\Dynprops;

$prefix = (isset($aData['prefix'])?$aData['prefix']:'dynprops');
$prefix_id = 'realty_dp_';

foreach($aData['dynprops'] as $d)
{
    $name = $prefix.'['.$d[$this->ownerColumn].']'.'['.$d['id'].']';
    $extra = 'dyntype="'.$d['type'].'" id="'.$prefix_id.$d['id'].'"';

    if($d['type'] == Dynprops::typeCheckbox) {
        $checkboxTitle = HTML::escape($d['title']);
    }
    $d['title'] .= ($d['req']?'<span class="z-att">*</span>':'');
    $extraClass = ($d['req']?'req':'');

    switch ($d['type'])
    {
         case Dynprops::typeRadioGroup:
        {
            $value = (isset($d['value']) && $d['value'] ? $d['value'] : $d['default_value']);
            ?><tr>
                <td class="td1"><?= $d['title']; ?></td>
                <td class="f12">
                <?

                    if($d['group_one_row'])
                    {
                        foreach($d['multi'] as $dm) {
                           echo '<label><input type="radio" name="'.$name.'" class="'.$extraClass.'" '.$extra.' title="'.$dm['name'].'" value="'.$dm['value'].'" '.($value == $dm['value'] ? 'checked="checked"' : '').'/> '.$dm['name'].'</label>&nbsp;';
                        }
                    } else {
                        echo $this->formCols($d['multi'], $value, create_function('$k,$dm,$value', '
                            return \'<li><label><input type="radio" name="'.$name.'" class="'.$extraClass.'" '.$extra.' title="\'.$dm[\'name\'].\'" value="\'.$dm[\'value\'].\'" \'.($value == $dm[\'value\']?\' checked="checked"\':\'\').\' /> \'.$dm[\'name\'].\'</label></li>\';'),
                            array('style'=>'margin-right: 7px;'));
                    }
                ?>
                </td>
              </tr><?
        }break;
        case Dynprops::typeRadioYesNo:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            ?><tr>
                <td class="td1"><?= $d['title']?></td>
                <td class="f12"><?= '<label><input type="radio" name="'.$name.'" '.$extra.' class="'.$extraClass.'" value="2" '.($value == 2?'checked="checked"':'').' /> Да</label>&nbsp;<label><input type="radio" name="'.$name.'" '.$extra.' class="'.$extraClass.'" value="1" '.($value == 1?'checked="checked"':'').' /> Нет</label>'
                    ?></td>
              </tr><?
        }break;
        case Dynprops::typeCheckboxGroup:
        {
            $value = ( isset($d['value']) && $d['value'] ? explode(';', $d['value']) : explode(';', $d['default_value']) );
            ?><tr>
                <td class="td1"><?= $d['title']?></td>
                <td class="f12" id="<?= $prefix_id.$d['id']; ?>">
                <?
                    $extra = 'dyntype="'.$d['type'].'"';

                    if($d['group_one_row'])
                    {
                        foreach($d['multi'] as $dm) {
                           echo '<label><input type="checkbox" name="'.$name.'[]" '.$extra.' class="'.$extraClass.'" title="'.$dm['name'].'" '.(in_array($dm['value'], $value)?'checked="checked"':'').' value="'.$dm['value'].'" />'.$dm['name'].'</label><br/>';
                        }
                    } else {
                        echo $this->formCols($d['multi'], $value, create_function('$k,$dm,$value', '
                            return \'<li><label><input type="checkbox" name="'.$name.'[]" '.$extra.' class="'.$extraClass.'" title="\'.$dm[\'name\'].\'" \'.(in_array($dm[\'value\'], $value)?\' checked="checked"\':\'\').\' value="\'.$dm[\'value\'].\'" /> \'.$dm[\'name\'].\'</label></li>\';'),
                            array('style'=>'margin-right: 7px;'));
                    }
                ?>
                </td>
              </tr><?
        }break;
        case Dynprops::typeCheckbox:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            ?><tr>
                <td class="td1"><?= $d['title']; ?></td>
                <td class="f12">
                    <?= '<input type="checkbox" name="'.$name.'" '.$extra.' class="'.$extraClass.'" title="'.$checkboxTitle.'" value="1" '.($value?'checked="checked"':'').' />' ?>
                </td>
              </tr><?
        }break;
        case Dynprops::typeSelect:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            if($d['parent']) {
               $extra .= ' ';
            ?><tr>
                <td class="td1"><?= $d['title']?></td>
                <td>
                    <div class="left">
                        <?= '<select name="'.$name.'" '.$extra.' onchange="addDynpropsParentSelect('.$d['id'].', this.value, \''.$prefix.'\');" class="'.$extraClass.'" style="width:185px;">' ?>
                        <?
                            foreach($d['multi'] as $dm) {
                               echo '<option value="'.$dm['value'].'" '.($value == $dm['value'] ? 'selected="selected"' : '').'>'.$dm['name'].'</option>';
                            }
                            $extra = 'dyntype="'.$d['type'].'"';
                        ?>
                        <?= '</select>' ?>
                    </div>
                    <div class="left"><?= $d['child_title'].':'.($d['req']?'<span class="z-att">*</span>':'')?>
                        <?= '<select disabled="disabled" name="'.$name.'" '.$extra.' id="'.$prefix_id.$d['id'].'_child" class="'.$extraClass.'"></select>' ?>
                    </div>
                    <div class="clear"></div>
                </td>
              </tr>
              <? } else { ?>
                  <tr>
                    <td class="td1"><?= $d['title']?></td>
                    <td><?= '<select name="'.$name.'" '.$extra.' class="'.$extraClass.'" style="width:185px;">' ?>
                        <?
                        foreach($d['multi'] as $dm) {
                           echo '<option value="'.$dm['value'].'" '.($value == $dm['value'] ? 'selected="selected"' : '').'>'.$dm['name'].'</option>';
                        } ?>
                        <?= '</select>' ?>
                    </td>
                  </tr><?
              }
        }break;
        case Dynprops::typeInputText:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            ?><tr>
                <td class="td1"><?= $d['title'] ?></td>
                <td class="f12"><?= '<div class="inp inp-w2"><input type="text" name="'.$name.'" '.$extra.' value="'.$value.'" class="'.$extraClass.'" /><i></i></div>'.( ! empty($d['description'])?' '.$d['description']:'') ?></td>
              </tr><?
        }break;
        case Dynprops::typeTextarea:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            ?><tr>
                <td class="td1"><?= $d['title']?></td>
                <td><?= '<textarea type="text" name="'.$name.'" '.$extra.' class="'.$extraClass.'" style="width:652px; height:80px;">'.$value.'</textarea>' ?></td>
              </tr><?
        }break;
        case Dynprops::typeNumber:
        {
            $value = (isset($d['value'])? $d['value'] : $d['default_value']);
            ?><tr>
                <td class="td1"><?= $d['title']?></td>
                <td class="f12">
                    <?= '<div class="inp inp-w2"><input type="text" name="'.$name.'" '.$extra.' value="'.$value.'" class="'.$extraClass.'" /><i></i></div>'.( ! empty($d['description'])?' '.$d['description']:'') ?>
                    <?
                        if($d['parent'] && isset($aData['children'][$d['id']])) {
                            echo $this->formChild($aData['children'][$d['id']], array('name'=>$prefix, 'class'=>$extraClass));
                        }
                    ?>
                </td>
              </tr><?
        }break;
        case Dynprops::typeRange:
        {
            $value = (isset($d['value']) && $d['value'] ? $d['value'] : $d['default_value']);
            ?><tr>
                <td class="td1"><?= $d['title'] ?></td>
                <td class="f12"><?= '<select name="'.$name.'" '.$extra.' class="'.$extraClass.'">' ?>
                    <?
                    if( ! empty($value) && !intval($value)) {
                        echo '<option value="0">'.$value.'</option>';
                    }
                    if($d['start'] <= $d['end']) {
                        for($i = $d['start']; $i <= $d['end'];$i += $d['step']) {
                           echo '<option value="'.$i.'" '.($value == $i ? 'selected="selected"' : '').'>'.$i.'</option>';
                        }
                    } else {
                        for($i = $d['start']; $i >= $d['end'];$i -= $d['step']) {
                           echo '<option value="'.$i.'" '.($value == $i ? 'selected="selected"' : '').'>'.$i.'</option>';
                        }
                    }
                     ?>
                    <?= '</select>' ?>
                    <?
                        if($d['parent'] && isset($aData['children'][$d['id']])) {
                            echo $this->formChild($aData['children'][$d['id']], array('name'=>$prefix, 'class'=>$extraClass));
                        }
                    ?>
                </td>
              </tr><?
        }break;
    }
}