<?php
/**
 * @var $this Services
 */
tpl::includeJS('tablednd', true);
?>
<?= tplAdmin::blockStart('ТВ программа / Каналы / Редактировать канал', false, array('id'=>'tvChannelFormBlock', 'style'=>'display:none;')); ?>
<form action="" method="post" name="tvChannelFormNew">
    <input type="hidden" name="act" value="add-finish" />
    <table class="admtbl tbledit">
        <tbody class="form_params"><?= $form ?></tbody>
        <tr>
            <td colspan="2" class="row1">
                <input type="submit" class="btn btn-success button submit" value="Сохранить" />
                <input type="reset" class="btn button cancel" value="Отмена" onclick="tvChannels.toggle('cancel');" />
            </td>
        </tr>
    </table>
</form>
<?= tplAdmin::blockStop(); ?>

<?= tplAdmin::blockStart('ТВ программа / Каналы'); ?>
<table class="table table-condensed table-hover admtbl tblhover" id="tv-channels-table">
<thead>
    <tr class="header nodrag nodrop">
        <? if(FORDEV) { ?><th width="50">ID</th><? } ?>
        <th class="left">Название</th>
        <th width="90">Действие</th>
    </tr>
</thead>
<? foreach($channels as $k=>$v) { $id = $v['id']; ?>
<tr class="row<?= $k%2 ?>" id="dnd-<?= $id ?>">
    <? if(FORDEV) { ?><td><?= $id ?></td><? } ?>
    <td class="left"><?= $v['title'] ?></td>
    <td>
        <a class="but <? if($v['enabled']){ ?>un<? } ?>block channel-toggle" title="Вкл/Выкл" href="#" rel="<?= $id ?>"></a>
        <a class="but <? if(!$v['main']){ ?>un<? } ?>fav channel-maintoggle" title="Основной" href="#" rel="<?= $id ?>"></a>
        <a class="but edit channel-edit" title="Редактировать" href="#" rel="<?= $id ?>"></a>
    </td>
</tr>
<? } if (empty($channels)) { ?>
<tr class="norecords">
    <td colspan="<?= (FORDEV ? 3 : 2) ?>">нет каналов</td>
</tr>
<? } ?>
</table>
<div>
    <div class="left">
        <? if(FORDEV) { ?><a href="#" onclick="tvChannels.cleanup('events'); return false;" class="desc ajax">очистить все данные о телепрограммах</a><? } ?>
    </div>
    <div class="right desc" style="width:60px; text-align:right;">
        <div class="progress" id="progress-tv-channels" style="display:none;"></div>
        &darr; &uarr;
    </div>
    <br />
</div>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
var tvChannels = (function(){
    var $progress, $block, $blockCaption, form, formClean, $list, fChecker;
    var ajax_url = '<?= $this->adminLink('tv_channels&act=') ?>';

    $(function(){
        form = document.forms.tvChannelFormNew;
        
        fChecker = new bff.formChecker(form);
        formClean = $(form).html();
        
        $progress = $('#progress-tv-channels');
        $block = $('#tvChannelFormBlock');
        $blockCaption = $block.find('span.caption'); 
        $list = $('#tv-channels-table');
        
        $list.on('click', 'a.channel-edit', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) edit( id );
            return false;
        });
        $list.on('click', 'a.channel-toggle', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.ajaxToggle(id, ajax_url+'toggle', {progress: $progress, link: this});
            }
            return false;
        });
        $list.on('click', 'a.channel-maintoggle', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.ajaxToggle(id, ajax_url+'maintoggle', {progress: $progress, link: this, unblock: 'unfav', block: 'fav'});
            }
            return false;
        });

        bff.rotateTable('#tv-channels-table', ajax_url+'rotate', $progress);
    });

    function toggle(type, editData)
    {                                           
        switch(type) {
            case 'cancel': {
                $block.hide();
            } break;
            case 'edit': {                           
                $blockCaption.html(editData.caption);
                $(form).find('.form_params').html(editData.form);
                $block.show();
                $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                form.elements['act'].value = 'edit-finish';
            } break;
        }
        fChecker.check(true, true);
        return false;
    }

    function edit(id)
    {                          
        bff.ajax(ajax_url+'edit&id='+id,{},function(data){
            if(data) {
                toggle('edit', $.extend({caption: 'ТВ программа / Каналы / Редактирование канала'}, data) );
            }                  
        }, $progress);
        return false;
    }

    function cleanup(type)
    {
        if( ! bff.confirm('sure')) return;

        bff.ajax(ajax_url+'cleanup',{type:type},function(data){
            if(data) {
                bff.success('Данные были успешно удалены');
            }
        }, $progress);
    }
    
    return {toggle: toggle, cleanup: cleanup};
}());
</script>