<?php

class Sitemap extends SitemapBase
{
    public function getMenu($bFindActive = true)
    {
        $this->buildMenu($bFindActive, false/* нет пункта меню, отмечаемого по-умолчанию */);

        # если нет компаний -> скрываем раздел "Работа > Компании"
        $bJobShowCompany = config::get('job_show_company', false);
        if (empty($bJobShowCompany)) {
            $this->removeMenuByPath('/main/job/company');
        }

        # пункты "Избранное"
        if (User::id()) {
            # заполняем счетчики избранных в пунктах "Избранное"
            $this->setMenuDataByPath('/main/bbs/fav', 'c', $this->security->userCounter('bbs_fav'));
            $this->setMenuDataByPath('/main/realty/fav', 'c', $this->security->userCounter('realty_fav'));
            $this->setMenuDataByPath('/main/auto/fav', 'c', $this->security->userCounter('auto_fav'));
            $this->setMenuDataByPath('/main/job/fav', 'c', $this->security->userCounter('job_fav'));
        } else {
            # удаляем пункты "Избранное"
            $this->removeMenuByPath('/main/bbs/fav');
            $this->removeMenuByPath('/main/realty/fav');
            $this->removeMenuByPath('/main/auto/fav');
            $this->removeMenuByPath('/main/job/fav');
        }

        return $this->menu;
    }

}