<?php
/**
 * @var $this Voting
 */
tpl::includeJS('tablednd', true);
tpl::includeJS('datepicker', true);
?>
<?= tplAdmin::blockStart('Голосования / Добавить голосование', false, array('id'=>'votingFormBlock', 'style'=>'display:none;')); ?>
    <form action="" method="post" name="votingFormNew">
        <?= $form; ?>
    </form>
<?= tplAdmin::blockStop(); ?>

<?= tplAdmin::blockStart('Голосования / Список', true, array(), array(
    'title'=>'+ создать голосование', 'class'=>'ajax', 'onclick'=>'return jVotings.toggle(\'add\');'
)) ?>
    <table class="table table-condensed table-hover admtbl tblhover" id="votings-table">
        <thead>
        <tr class="header nodrag nodrop">
            <th width="50">ID</th>
            <th class="left">Название</th>
            <th width="140">Открыто</th>
            <th width="140">Закрыто</th>
            <th width="80">Действие</th>
        </tr>
        </thead>
        <tbody id="j-voting-list"><?= $list ?></tbody>

    </table>
    <div>
        <div class="left">

        </div>
        <div class="right desc" style="width:60px; text-align:right;">
            <div class="progress" id="progress-votings" style="display:none;"></div>
        </div>
    </div>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
    var jVotings = (function(){
        var $progress, $block, $blockCaption, form, formClean, $list, fChecker;
        var ajax_url = '<?= $this->adminLink('listing&act=') ?>';

        $(function(){
            form = document.forms.votingFormNew;

            fChecker = new bff.formChecker(form);
            formClean = $(form).html();

            $progress = $('#progress-votings');
            $block = $('#votingFormBlock');
            $blockCaption = $block.find('span.caption');
            $list = $('#j-voting-list');

            $list.on('click', 'a.voting-edit', function(){
                var id = intval($(this).attr('rel'));
                if(id>0) edit( id );
                return false;
            });

            $list.on('click', 'a.voting-del', function(){
                var id = intval($(this).attr('rel'));
                if(id>0) del( id, this );
                return false;
            });

            var $form = $(form);
            $form.on('click', 'a.answers-del', function(){
                var $block = $(this).closest('.answer');
                if($block.hasClass('dyn')) {
                    $block.remove();
                } else {
                    $block.hide();
                    $block.find('.del_mark').val(1);
                }
                return false;
            });
            $form.submit(function(){
                bff.ajax('', $form.serialize(), function(data, errors){
                    if(data && data.success){
                        toggle('cancel');
                        form.reset();
                    }
                }, $progress);
                return false;
            });

        });

        function toggle(type, editData)
        {
            switch(type) {
                case 'add': {
                    if($block.is(':hidden')) {
                        $block.show();
                        $(form).html(formClean);
                        $blockCaption.html('Голосования / Создать голосование');
                        $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                        answersFactory();
                        initDatepickers();
                    } else {
                        $block.hide();
                    }
                } break;
                case 'cancel': {
                    $block.hide();
                    updateList();
                } break;
                case 'edit': {
                    $blockCaption.html(editData.caption);
                    $(form).html(editData.form);
                    $block.show();
                    $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                    form.elements['act'].value = 'edit-finish';
                    answersFactory();
                    initDatepickers();
                } break;
            }
            fChecker.check(true, true);
            return false;
        }

        function answersFactory()
        {
            var $block = $(form).find('.answers-block');
            var i = $block.find('.answer').length;
            var $list = $block.find('.answers-list');
            $block.find('.answers-add').click(function(e){
                nothing(e);
                var prefix = 'answers['+i+']';
                var tBlock = '<?= $this->locale->formField('{prefix}[t]', array(), 'text', array('class' => 'text-field left voting-answer', 'style' => 'margin-bottom: 1px; width: 300px;', 'placeholder' => 'вариант ответа', 'maxlength' => '40')); ?>';
                tBlock = tBlock.replace(/\{prefix\}/g, prefix);
                ++i;
                $list.append('<tr><td class="answer dyn more-langs answer'+i+'">\
                <input type="hidden" name="answers['+i+'][id]" value="0" />\
                <input type="hidden" name="answers['+i+'][del]" value="0" class="del_mark" />\
                '+tBlock+'\
                <div class="left" style="margin: 5px 0 0 5px;"><a href="#" class="but cross answers-del"></a></div>\
                <div class="clear"></div>\
              </td></tr>');
                $list.find('.answer'+i+' > .text-field').focus();
                $list.tableDnDUpdate();
            });

            $list.tableDnD({});

        }

        function initDatepickers()
        {
            var dateMin = new Date(<?= date('Y,n,d', mktime(0,0,0,date('n')-1, date('d'), date('y'))); ?>);
            bff.datepicker($('#j-start', $block), {minDate: dateMin, yearRange: '-2:+2'});
            bff.datepicker($('#j-finish', $block), {minDate: dateMin, yearRange: '-2:+2'});
        }

        function del(id, link)
        {
            bff.ajaxDelete('Удалить голосование?', id,
                ajax_url+'delete&id='+id,
                link, {progress: $progress, repaint: false});
            return false;
        }

        function edit(id)
        {
            bff.ajax(ajax_url+'edit&id='+id,{},function(data){
                if(data) {
                    toggle('edit', $.extend({caption: 'Голосования / Редактирование голосования'}, data) );
                }
            }, $progress);
            return false;
        }

        function updateList()
        {
            bff.ajax(ajax_url, {}, function(data){
                if(data) {
                    $list.html( data.list );
                }
            }, $progress);
        }


        return {
            toggle: toggle
        };
    }());
</script>