<?php

define('TABLE_VOTING',          DB_PREFIX.'voting');
define('TABLE_VOTING_ANSWERS',  DB_PREFIX.'voting_answers'); 
define('TABLE_VOTING_VOTES',    DB_PREFIX.'voting_votes'); 

abstract class VotingBase extends Module
{
    /** @var VotingModel */
    public $model = null;
    protected $securityKey = '0b6c0f69225d2676f1fa8eddb41f343d';
    
    # Статус голосования
    const STATUS_NEW    = 0; # новое
    const STATUS_OPENED = 1; # открыто
    const STATUS_CLOSED = 2; # закрыто

    function init()
    {
        parent::init();

        $this->module_title = 'Голосования';
    }

    /**
     * Shortcut
     * @return Voting
     */
    public static function i()
    {
        return bff::module('voting');
    }

    /**
     * Shortcut
     * @return VotingModel
     */
    public static function model()
    {
        return bff::model('voting');
    }

    /**
     * Формирование URL
     * @param string $key ключ
     * @param mixed $opts параметры
     * @param boolean $dynamic динамическая ссылка
     * @return string
     */
    public static function url($key = '', $opts = array(), $dynamic = false)
    {
        $base = static::urlBase(LNG, $dynamic);
        switch ($key)
        {
            # Список
            case 'list':
                return $base.'/services/voting/'.static::urlQuery($opts);
                break;
        }
        return $base;
    }

    /**
     * Формирование блока для голосования
     * @param int $nVotingID ID голосования
     * @param bool $bResult true - выводить результат голосования; false - выводить форму для голосования
     * @param array|bool $aData данные о голосовании или FALSE
     * @param bool $bRightblock true - блок будет выводиться в правой колонке
     * @return string HTML
     */
    function getVotingBlock($nVotingID, $bResult, $aData = false, $bRightblock = true)
    {
        if( ! $nVotingID) {
            return '';
        }
        
        if($aData === false) {
            $aData = $this->db->one_array('SELECT *, title_'.LNG.' AS title FROM '.TABLE_VOTING.' WHERE id = :id', array(':id'=>$nVotingID));
            if (empty($aData)) {
                return '';
            }
            $aData['answers'] = $this->db->select('SELECT *, title_'.LNG.' AS title FROM '.TABLE_VOTING_ANSWERS.'
                                    WHERE voting_id = :vid ORDER BY num', array(':vid'=>$nVotingID));
        }
        
        $aData['rightblock'] = $bRightblock;
        if($bResult) {
            return $this->viewPHP($aData, 'voting.result');
        } else {
            return $this->viewPHP($aData, 'voting.form');
        }
    }

    /**
     * Голосовал ли пользователь
     * @param int $nUserID ID пользователя
     * @param int $nVotingID ID голосования
     * @param int|bool $nStatus статус голосования или FALSE
     * @return bool true - выводить форму для голосования, false - не выводить
     */
    function isUserVoted($nUserID, $nVotingID, $nStatus = false)
    {
        $bForm = false;
        if($nUserID > 0)
        {
           $aVote = $this->db->one_array('SELECT * FROM '.TABLE_VOTING_VOTES.'
                    WHERE voting_id = :id AND user_id = :uid',
                    array(':id'=>$nVotingID, ':uid'=>$nUserID));
            if (empty($aVote)) { # пользователь еще не проголосовал
                $bForm = true;
            }
        } else {
            $bForm = true;
        }
        
        if($nStatus!==false && $nStatus === self::STATUS_CLOSED) {
            # если голосование закрыто, форму не выводим
            $bForm = false;
        }
        
        return ! $bForm;
    }

}