var appComments = (function()
{
    var o = {lang:{}}, $block, $error, $text, $counter;
    var formReplyID = 0, iCommentLast = 0;

    function responseNewComment(selfIdComment)
    {
        setTimeout(function(){ bff.ajax(o.url+'?act=comment-response', {'comment_id_last': iCommentLast}, function(data)
        {
            if(!data || !data.success) return;
            var aCmt = data.aComments;
            if (aCmt.length > 0 && data.nMaxIdComment) {
                iCommentLast = data.nMaxIdComment;
            }
            if (selfIdComment) {
                formShow(0);
                $text.prop('disabled', false);
            }

            $.each(aCmt, function(i,comm) {
                // inject comment
                var commDiv = $(document.createElement('div'));
                commDiv.addClass( (comm.pid > 0 ? 'b-answer' : 'b-comment') ).data('id',comm.id).html(comm.html);
                if (comm.pid) {
                    var divChildren = $('.j-comment-children-'+comm.pid, $block);
                    if (divChildren.length) {
                        divChildren.append(commDiv);
                    }
                } else {
                    commDiv.insertBefore( $('.j-comment-children-0', $block) );
                }
            });
            console.log(data);
        }); }, 1000);
    }

    function formShow(commentID, userName)
    {
        var formCurrent = $('.j-comment-reply-' + formReplyID, $block);
        var formNext    = $('.j-comment-reply-' + commentID, $block);
        if ( ! formCurrent.length || ! formNext.length) {
            return;
        }
        
        $('.j-cancel', $block).toggle(commentID > 0);
        
        if (formReplyID == commentID) {
            formCurrent.show();
            $text.focus().val((userName ? userName+', ': '')).keyup();
            return;
        }
        
        formCurrent.hide();
        $('.j-form', $block).appendTo(formNext);
        formNext.show();

        $error.hide();
        $text.focus().val((userName ? userName+', ': '')).keyup();
        $('.j-form-reply-id', $block).val(commentID);
        formReplyID = commentID;
    }

    return {
        init: function(opts){
            o = $.extend({url:'', block:false, lastID:0}, opts||{});
            $block = $(o.block);
            $error = $block.find('.j-error');
            $text = $block.find('.j-form-text:first');
            $counter = $block.find('.j-counter');
            iCommentLast = o.lastID;

            $block.on('click', '.j-comment-link', function(e){ nothing(e);
                formShow(intval($(this).data('parent')), $(this).data('name'));
            });
            $block.on('click', '.j-submit', function(e){ nothing(e);
                var $btn = $(this);
                if ( ! $text.val().length) {
                    $text.focus(); return;
                }
                bff.ajax(o.url + '?act=comment-add&hash='+app.csrf_nonce, $('.j-form', $block).serialize(), function(data, errors){
                    if(data && data.success) {
                        $text.val('').prop('disabled', true);
                        responseNewComment(data.comment_id);
                        $error.hide();
                        $counter.html(data.total);
                    } else {
                        app.showError($error, errors);
                    }
                }, function(p) {
                    $btn.prop('disabled', p);
                });
            });
            bff.maxlength($text, {
                limit: o.maxlength, cut: false,
                message: $('.j-form-text-limit', $block),
                //onChange: function($e) { app.inputError($e, ! $.trim($e.val()).length ); },
                lang: {
                    left: o.lang.maxlength_symbols_left,
                    symbols: o.lang.maxlength_symbols.split(';')
                }
            });
        }
    };
}());