
<div class="row dashboard">
    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
        <div class="panel panel-blue">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-play-circle fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge loading" id="totalVideos">0</div>
                        <div><?php echo __("Total Videos"); ?></div>
                    </div>
                </div>
            </div>
            <a href="<?php echo $global['webSiteRootURL']; ?>mvideos">
                <div class="panel-footer">
                    <span class="pull-left"><?php echo __("View Details"); ?></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
        <div class="panel panel-primary">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-eye fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge loading" id="totalVideosViews">0</div>
                        <div><?php echo __("Total Videos Views"); ?></div>
                    </div>
                </div>
            </div>
            <a href="<?php echo $global['webSiteRootURL']; ?>mvideos">
                <div class="panel-footer">
                    <span class="pull-left"><?php echo __("View Details"); ?></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
        <div class="panel panel-purple">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-users fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge loading" id="totalUsers">0</div>
                        <div><?php echo __("Total Users"); ?></div>
                    </div>
                </div>
            </div>
            <a href="<?php echo $global['webSiteRootURL']; ?>users">
                <div class="panel-footer">
                    <span class="pull-left"><?php echo __("View Details"); ?></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
        <div class="panel panel-wine">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-user-plus fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge loading" id="totalSubscriptions">0</div>
                        <div><?php echo __("Total Subscriptions"); ?></div>
                    </div>
                </div>
            </div>
            <a href="<?php echo $global['webSiteRootURL']; ?>subscribes">
                <div class="panel-footer">
                    <span class="pull-left"><?php echo __("View Details"); ?></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>


    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
        <div class="panel panel-red">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-comments fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge loading" id="totalVideosComents">0</div>
                        <div><?php echo __("Total Video Comments"); ?></div>
                    </div>
                </div>
            </div>
            <a href="<?php echo $global['webSiteRootURL']; ?>comments">
                <div class="panel-footer">
                    <span class="pull-left"><?php echo __("View Details"); ?></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
        <div class="panel panel-orange">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-thumbs-o-up fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge loading" id="totalVideosLikes">0</div>
                        <div><?php echo __("Total Videos Likes"); ?></div>
                    </div>
                </div>
            </div>
            <a href="<?php echo $global['webSiteRootURL']; ?>mvideos">
                <div class="panel-footer">
                    <span class="pull-left"><?php echo __("View Details"); ?></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
        <div class="panel panel-yellow">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-thumbs-o-down fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge loading" id="totalVideosDislikes">0</div>
                        <div><?php echo __("Total Videos Dislikes"); ?></div>
                    </div>
                </div>
            </div>
            <a href="<?php echo $global['webSiteRootURL']; ?>mvideos">
                <div class="panel-footer">
                    <span class="pull-left"><?php echo __("View Details"); ?></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
        <div class="panel panel-green">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-clock-o fa-5x"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <div class="huge loading" id="totalDurationVideos">0</div>
                        <div><?php echo __("Total Duration Videos (Minutes)"); ?></div>
                    </div>
                </div>
            </div>
            <a href="<?php echo $global['webSiteRootURL']; ?>mvideos">
                <div class="panel-footer">
                    <span class="pull-left"><?php echo __("View Details"); ?></span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
</div>
<nav class="navbar navbar-default nav-chart">
    <div class="container-fluid">
        <div class="btn-group">
            <button class="btn btn-primary navbar-btn active" id="btnAll" ><?php echo __("Total Views"); ?></button>
            <button class="btn btn-warning navbar-btn" id="btnToday"><?php echo __("Today Views"); ?></button>
            <button class="btn btn-default navbar-btn" id="btn7"><?php echo __("Last 7 Days"); ?></button>
            <button class="btn btn-default navbar-btn" id="btn30" ><?php echo __("Last 30 Days"); ?></button>
            <!--
            <button class="btn btn-default navbar-btn" id="btnUnique" ><?php echo __("Unique Users"); ?></button>
            --></div>
    </div>
</nav>
<div class="col-md-3">

    <div class="panel panel-default">
        <div class="panel-heading when"><?php echo __("Color Legend"); ?></div>
        <div class="panel-body" style="height: 600px; overflow-y: scroll;">
            <div class="list-group">

                <?php
                foreach ($labelsFull as $key => $value) {
                    ?>
                    <a class="list-group-item " style="border-color: <?= $bg[$key] ?>; border-width: 1px 20px 1px 5px; font-size: 0.9em;">
                        <?= $value ?>
                    </a>
                    <?php
                }
                ?>
            </div>
        </div>
    </div>
</div>
<div class="col-md-9">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading when"># <?php echo __("Total Views"); ?></div>
                <div class="panel-body">
                    <canvas id="myChart" height="60" ></canvas>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <div class="panel panel-default">
                <div class="panel-heading when"># <?php echo __("Total Views"); ?></div>
                <div class="panel-body">
                    <canvas id="myChartPie" height="200"  ></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="panel panel-default">
                <div class="panel-heading when"># <?php echo __("Timeline"); ?></div>
                <div class="panel-body" id="timeline">
                    <canvas id="myChartLine" height="90"  ></canvas>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading when"># <?php echo __("Total Views Today"), " - ", date("Y-m-d"); ?></div>
                <div class="panel-body">
                    <canvas id="myChartLineToday" height="60" ></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<script>

    function countTo(selector, total) {
        current = parseInt($(selector).text());
        total = parseInt(total);
        if (!total || current >= total) {
            $(selector).removeClass('loading');
            return;
        }
        var rest = (total - current);
        var step = parseInt(rest / 100);
        if (step < 1) {
            step = 1;
        }
        current += step;
        $(selector).text(current);
        var timeout = (500 / rest);
        setTimeout(function () {
            countTo(selector, total);
        }, timeout);
    }

    var ctx = document.getElementById("myChart");
    var ctxPie = document.getElementById("myChartPie");
    var ctxLine = document.getElementById("myChartLine");
    var ctxLineToday = document.getElementById("myChartLineToday");
    var chartData = {
        labels: <?php echo json_encode($labelsFull); ?>,
        datasets: [{
                label: '# <?php echo __("Total Views"); ?>',
                data: <?php echo json_encode($datas); ?>,
                backgroundColor: <?php echo json_encode($bg); ?>,
                borderColor: <?php echo json_encode($bc); ?>,
                borderWidth: 1
            }]
    };

    var lineChartData = {
        labels: <?php echo json_encode($label90Days); ?>,
        datasets: [{
                backgroundColor: 'rgba(255, 0, 0, 0.3)',
                borderColor: 'rgba(255, 0, 0, 0.5)',
                label: '# <?php echo __("Total Views (90 Days)"); ?>',
                data: <?php echo json_encode($statistc_last90Days); ?>
            }]
    };

    var lineChartDataToday = {
        labels: <?php echo json_encode($labelToday); ?>,
        datasets: [{
                backgroundColor: 'rgba(0, 0, 255, 0.3)',
                borderColor: 'rgba(0, 0, 255, 0.5)',
                label: '# <?php echo __("Total Views (Today)"); ?>',
                data: <?php echo json_encode($statistc_lastToday); ?>
            }]
    };

    var myChart = new Chart(ctx, {
        type: 'bar',
        data: chartData,
        options: {
            scales: {
                yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function (value, index, values) {
                                if (Math.floor(value) === value) {
                                    return value;
                                }
                            }
                        }
                    }],
                xAxes: [{
                        display: false
                    }]
            },
            legend: {
                display: false
            },
            responsive: true
        }
    });
    var myChartPie = new Chart(ctxPie, {
        type: 'pie',
        data: chartData,
        options: {
            legend: {
                display: false
            },
            responsive: true
        }
    });

    var myChartLine = new Chart(ctxLine, {
        type: 'line',
        data: lineChartData,
        fill: false,
        options: {
            scales: {
                yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function (value, index, values) {
                                if (Math.floor(value) === value) {
                                    return value;
                                }
                            }
                        }
                    }]
            },
            legend: {
                display: false
            },
            responsive: true,
            title: {
                display: true
            }
        }
    });

    var myChartLineToday = new Chart(ctxLineToday, {
        type: 'line',
        data: lineChartDataToday,
        fill: false,
        options: {
            scales: {
                yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function (value, index, values) {
                                if (Math.floor(value) === value) {
                                    return value;
                                }
                            }
                        }
                    }]
            },
            legend: {
                display: false
            },
            responsive: true,
            title: {
                display: true
            }
        }
    });

    $(document).ready(function () {
        countTo('#totalVideos', <?php echo $totalVideos; ?>);
        countTo('#totalUsers', <?php echo $totalUsers; ?>);
        countTo('#totalSubscriptions', <?php echo $totalSubscriptions; ?>);
        countTo('#totalVideosComents', <?php echo $totalComents; ?>);
        countTo('#totalVideosLikes', <?php echo $totalInfos->likes; ?>);
        countTo('#totalVideosDislikes', <?php echo $totalInfos->disLikes; ?>);
        countTo('#totalVideosViews', <?php echo $totalInfos->views_count; ?>);
        countTo('#totalDurationVideos', <?php echo $totalInfos->total_minutes; ?>);

        $('#btnAll').click(function () {
            $('.nav-chart .btn').removeClass('active');
            $(this).addClass('active');
            chartData.datasets[0].data = <?php echo json_encode($datas); ?>;
            chartData.datasets[0].label = '# <?php echo __("Total Views"); ?>';
            lineChartData.labels = <?php echo json_encode($label90Days); ?>;
            lineChartData.datasets[0].data = <?php echo json_encode($statistc_last90Days); ?>;
            lineChartData.datasets[0].label = '# <?php echo __("Total Views (90 Days)"); ?>';
            myChart.update();
            myChartPie.update();
            myChartLine.update();
        });
        $('#btnToday').click(function () {
            $('.nav-chart .btn').removeClass('active');
            $(this).addClass('active');
            chartData.datasets[0].data = <?php echo json_encode($datasToday); ?>;
            chartData.datasets[0].label = '# <?php echo __("Today"); ?>';
            lineChartData.labels = <?php echo json_encode($labelToday); ?>;
            lineChartData.datasets[0].data = <?php echo json_encode($statistc_lastToday); ?>;
            lineChartData.datasets[0].label = '# <?php echo __("Today"); ?>';
            myChart.update();
            myChartPie.update();
            myChartLine.update();
        });
        $('#btn7').click(function () {
            $('.nav-chart .btn').removeClass('active');
            $(this).addClass('active');
            chartData.datasets[0].data = <?php echo json_encode($datas7); ?>;
            chartData.datasets[0].label = '# <?php echo __("Last 7 Days"); ?>';
            lineChartData.labels = <?php echo json_encode($label7Days); ?>;
            lineChartData.datasets[0].data = <?php echo json_encode($statistc_last7Days); ?>;
            lineChartData.datasets[0].label = '# <?php echo __("Last 7 Days"); ?>';
            myChart.update();
            myChartPie.update();
            myChartLine.update();
        });
        $('#btn30').click(function () {
            $('.nav-chart .btn').removeClass('active');
            $(this).addClass('active');
            chartData.datasets[0].data = <?php echo json_encode($datas30); ?>;
            chartData.datasets[0].label = '# <?php echo __("Last 30 Days"); ?>';
            lineChartData.labels = <?php echo json_encode($label30Days); ?>;
            lineChartData.datasets[0].data = <?php echo json_encode($statistc_last30Days); ?>;
            lineChartData.datasets[0].label = '# <?php echo __("Last 30 Days"); ?>';
            myChart.update();
            myChartPie.update();
            myChartLine.update();
        });
        $('#btnUnique').click(function () {
            $('.nav-chart .btn').removeClass('active');
            $(this).addClass('active');
            chartData.datasets[0].data = <?php echo json_encode($datasUnique); ?>;
            chartData.datasets[0].label = '# <?php echo __("Unique Users"); ?>';
            myChart.update();
            myChartPie.update();
        });
    });
</script>